﻿/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2004 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: 
//
// NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally don't change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//Brazilian Portuguese (pt-br)
//
/////////////////////////////////////////////

//////////////////////////////////////////////
///// Add as ECO17 Direct Addition to the Privacy Policy 
/////
var xmsgGatherInfoDuringInstall= "제품 활성화 중에 수집된 모든 데이터는 Autodesk 기준에 따라 사용됩니다. ";
var xmsgOfflinePrivacyWarning= "인터넷에 연결되지 않는 경우 Internet Explorer(R) 브라우저의 인코딩을 자동 선택으로 설정하면 개인 정보 보호 정책을 볼 수 있습니다. 인터넷에 액세스할 수 있는 경우에는 autodesk.com에서 개인 정보 보호 정책을 확인할 수 있습니다."
////////////////////////////////////////////////////

var xmsgProductLanguage=	"ko";

/////////////////////////////////////////////
// Disable field color
/////////////////////////////////////////////
var xmsgDisableColor=		"#7f7f7f";

var xmsgNavigationBGColor=	"#f4f4f4";
var xmsgNavigationDisableColor=	"#808080";

/////////////////////////////////////////////
// HTML FILE TITLE STRINGS
/////////////////////////////////////////////
var xmsgRTAuthConfirmed=				"활성화 완료";
var xmsgRTActLicFound=                  "활성화된 라이센스가 발견되었습니다";
var xmsgRTActLicFoundError=            "등록 - 활성화 오류"; 
var xmsgRTAuthEntryError=				"활성화 입력 오류";
var xmsgRTAuthError=					"활성화 오류";
var xmsgRTAuthNow=						"지금 권한 부여";
var xmsgRTBeginReg=						"활성화 옵션";
var xmsgRTBuyInformation=				"구매 정보";
var xmsgRTConfirm=						"사용자 확인";
var xmsgRTConnect=						"인터넷 연결 필요";
var xmsgRTConnectFail=					"연결 오류";
var xmsgRTContactAutodesk=				"Autodesk에 문의";
var xmsgRTCountryPage=					"국가";
var xmsgRTEmail=						"전자 우편";
var xmsgRTFaxUS=						"사용자 팩스(미국)";
var xmsgRTMailUS=						"사용자 메일(미국)";
var xmsgRTPurchaseOffline=				"오프라인 구매";
var xmsgRTRegConfirmed=					"등록이 확인되었습니다";
var xmsgRTExportConfirm=                "라이센스 내보내기 확인";
var xmsgRTImportConfirm=                "라이센스 가져오기 확인"; 
var xmsgRTRegVol=						"제품 등록";
var xmsgRTSUNDataConfirm=				"SUN 데이터 확인";
var xmsgRTSUNServer=					"SUN 서버";
var xmsgRTSUNSubmit=					"사용자 확인/SUN 제출";
var xmsgRTUserInfo=						"사용자 정보";
var xmsgRTLicFileSaveError=				"Flexlm 라이센스 파일 저장 오류";
var xmsgRTProductInfo=                   "제품 정보 필요";
var xmsgNSARTBegin=						"네트워크 라이센스 얻기";
var xmsgNSARTLocateLicense=				"라이센스 파일 찾기";
var xmsgNSARTEditServerAndSeat=			"서버 정보 입력 또는 수정";
var xmsgNSARTConfirmServerAndSeat=		"서버 정보 확인";
var xmsgNSARTEnterSN=					"일련 번호 입력";
var xmsgProcessingError=				"처리 오류";
var xmsgTimeout=        				"이 세션은 시간 종료되었습니다";
var xmsgLicenseActivation=        		"활성화 중";
var xmsgLicenseTransfer=        		"라이센스 전송";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgActivationFor=	"활성화 대상:";
var xmsgPurchase=       "구입:";
var xmsgRegistrationFor=       "등록 대상:";
var xmsgProduct=	"제품: ";
var xmsgsernum=		"일련 번호: ";
var xmsgsernumWGID=	"일련 번호: ";//modify by joyce.min on 2007-8-16
var xmsgprokeyWGID=  "제품 키: "; // add by  joyce.min on 2007-8-16
var xmsgOsernum=	"이전 일련 번호: ";
//var xmsgOprokey=      "Previous product key: "; // add by joyce.min on 2007-8-17
var xmsgOldSerialNum=	"이전 일련 번호:*";
var xmsgNewSernum1=	"일련 번호 또는 그룹 ID 입력:"; //???
//var xmsgNewProkey1=
var xmsgRequestCode=	"요청 코드: ";
var xmsgRegAuthCode=	"활성화 코드: ";
var xmsgApplicationKey=	"응용프로그램 키: ";
var xmsgRTHostID=				"호스트 ID:";
var xmsgRTFlexlmLicenseFile=	"라이센스 파일:";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"호칭:";
var xmsgNone=		"(없음)";
var xmsgNotEntered=	"(입력 안 함)";
var xmsgFirstname=	"이름:";
//var xmsgFirstname= langCode+label.fname;
var xmsgFirstnameKanji=	"이름(칸지):";
var xmsgFirstnameFurigana=	"이름(젠카쿠 카나):";
var xmsgLastname=	"성:";
var xmsgLastnameKanji=	"성(칸지):";
var xmsgLastnameFurigana=	"성(젠카쿠 카나):";
var xmsgCompanyName=	"회사명:*";
var xmsgCompanyName2=	"회사명:";
var xmsgCompanyNameJP=	"회사명(칸지):";
var xmsgPhone=		"전화 번호:";
var xmsgArea=		"지역:";
var xmsgNumber=		"번호:";
var xmsgExt=		"내선 번호:";
var xmsgFax=		"팩스 번호:";
var xmsgFaxTo=		"팩스 수신자 ";
var xmsgEmail=		"전자 우편:";
var xmsgEmailTo=	"전자 우편 수신자 ";
var xmsgAddress=	"주소:";
var xmsgAddress2=	"주소 2:";
var xmsgAddress3=	"주소 3:";
var xmsgJPAddress=	"마을:";
var xmsgJPAddress2=	"주소:";
var xmsgJPAddress3=	"건물 이름(호수):";
var xmsgCity=		"도시:";
var xmsgSRP=		"도/시/구(읍/면/동):";
var xmsgStText=		"도:";
var xmsgPrText=		"시:";
var xmsgRegText=	"구(읍/면/동):";
var xmsgPrefectureText=	"군:";
var xmsgCountyText=	"지자체:";
var xmsgCantonText=	"읍:";
var xmsgZipCode=	"우편 번호:";
var xmsgPostCode=	"우편 번호:";
var xmsgCountry=	"국가 또는 지역:";
var xmsgDealer=		"Autodesk 공인 리셀러 이름:";
var xmsgMailTo=		"우편 수신자 ";
var xmsgAnEmail=	"전자 우편 주소";
var xmsgAFax=		"팩스 번호";
var xmsgAMailAddress=	"우편 주소";
var xmsgPostalMail=		"우편 메일";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"뒤로";
var xmsgCancel=			"닫기";
var xmsgNext=			"다음";
var xmsgPrint=			"인쇄";
var xmsgPrintForm=		"활성화 요청 양식 열기";
var xmsgNo=				"아니오";
var xmsgYes=			"예";
var xmsgBrowse=			"찾아보기";
var xmsgDone=			"완료";
var xmsgOK=				"확인";
var xmsgClose=			"닫기";
var xmsgSubmit=			"제출";
var xmsgFinish=			"마침";
var xmsgReset=			"모두 지우기";

///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"선택하십시오 ";
var xmsgPleaseSelect2=		"%1 라이센스를 즉시 활성화하려면 \"지금 연결 및 활성화!\”를 다시 선택합니다. 그래도 활성화 도중 문제가 발생하는 경우, Autodesk에 요청하여 받은 활성화 코드가 있으면 \"Autodesk에서 받은 활성화 코드가 있습니다\"를 선택합니다.";
var xmsgSelectCountry=		"제품을 사용할 국가/지역:";
var xmsgSelectCountry2=		"국가/지역:";
var xmsgInformation=		"정보";
var xmsgCompanyInfo=		"회사 정보:";
var xmsgContactInfo=		"연락처 정보:";
var xmsgResponseMethodInfo=	"응답 방법:"; //modify as the Spec. recommond by joyce.min on 2007-8-17
var xmsgFormSubmitMethodInfo=	"양식 제출 방법:";
var xmsgConfirmInfo=		"확인 정보";
var xmsgConfirmInfoTxt=		"다음 정보를 검토하십시오. 양식 제출 방법 링크 중 하나를 클릭하고 아래 정보를 사용하여 계속 진행하십시오. 변경하려면 뒤로를 클릭하십시오.";
var xmsgConfirmCustIDInfoTxt=		"다음 정보를 확인하십시오. 계속하려면 다음을 클릭하고, 변경하려면 뒤로를 클릭하십시오.";
var xmsgCountryHdr=			"제품 등록";
var xmsgCountryRegTo=		"이 제품 등록 대상:";
var xmsgCountryComp=		"회사";
var xmsgCountryIndiv=		"개인";
var xmsgCountryUpgrade=		"업그레이드입니다.";
var xmsgCountryUpgDetail=	"(Subscription 고객인 경우, 아니오를 클릭하십시오)";
var xmsgConnectHdr1=		"연결 중";
var xmsgConnectHdr2 = "제품 라이센스 활성화 중…";
var xmsgConnectHdr = "인터넷 연결 필요";
var xmsgConnectMsg=		"연결";
var xmsgConnectTxt=		"인터넷 연결이 감지되지 않습니다. 온라인으로 활성화하려면 지금 인터넷에 연결하십시오. 연결되면 다음을 클릭하십시오.";
var xmsgConnectTxtOLT=    "인터넷 연결이 감지되지 않습니다. 라이센스를 전송하려면 지금 인터넷에 연결하십시오.";
var xmsgConnectTxt2=	"인터넷에 연결되면 다음을 클릭하십시오.";
var xmsgConnectTxt3=	"인터넷에 연결할 수 없으면 오프라인으로 Autodesk에 활성화 코드를 요청하십시오.";
var xmsgConnectWarming=	"정보를 제출하는 데 몇 분이 걸릴 수 있습니다. 잠시 기다리십시오.";
var xmsgTryAgain=		"다시 시도";
var xmsgReEnterOld=		"이전 일련 번호를 다시 입력하십시오";
var xmsgNewSernum3=		"새 일련 번호를 입력한 후 다음 버튼을 클릭하십시오.";
var xmsgNewSernum4=		"이 소프트웨어 평가판은 등록할 수 없는 일련 번호(000-00000000)로 " +
						"설치되어 있습니다. 이 소프트웨어를 구매한 사용자에게는 " +
						"새 일련 번호가 발급됩니다. 발급된 새 일련 번호로 제품을 활성화하고 " +
						"사용할 수 있도록 해야 합니다.";
var xmsgNewSernum5=		"일련 번호 입력:"; //modify by joyce.min on 2007-8-16
var xmsgProductKey=      "제품 키 입력:"; //modify by joyce.min on 2007-8-16
var xmsgNewSernum6=		"새 일련 번호 확인:";
var xmsgNewSernum8=		"새 일련 번호 다시 입력";
var xmsgUseOtherMethod=		"다른 등록 방법 사용";
var xmsgContactAutodesk=	"Autodesk에 문의";
var xmsgContactAutodeskLink="Autodesk에 문의하려면 다음 링크를 클릭하십시오.";
var xmsgContactOptions=		"연락 옵션은 아래에 나와 있습니다.";

var xmsgPuchaseInfo1=		"구매 정보";
var xmsgPuchaseInfo2=		"온라인 구매를 선택했습니다."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min
var xmsgPuchaseInfo3=		"계속하려면 다음 버튼을 클릭하고, 중단하려면 취소 버튼을 클릭하십시오."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min

var xmsgRegTitle=		"등록 - 활성화";
var xmsgRegTitleBuy=		"Autodesk 제품 온라인 구매";
var xmsgRegTitleNSA=		"네트워크 라이센스 활성화";
var xmsgRegInfo=		"고객 정보";
var xmsgRegInfo2=		"등록 방법";
var xmsgRegInfo3=		"등록 방법을 선택한 후 다음 버튼을 클릭하십시오.";
var xmsgRegmethod1=		"인터넷을 통해 직접 연결";
var xmsgRegmethod3=		"활성화 코드 수신 방법:";
var xmsgRegmethod5=		"우편";
var xmsgRegmethod6=		"아래의 인쇄 버튼을 클릭하고 이 양식을 우편으로 보내십시오.";
var xmsgRegmethod7=		"팩스";
var xmsgRegmethod8=		"%1에서 Autodesk 팩스 전송 양식을 인쇄하려면 먼저 활성화 코드의 수신 방법을 "+
						"선택하고 인쇄를 클릭하십시오. "+
						"그러면 양식을 팩스로 보낼 수 있습니다.";
var xmsgRegmethod9=		"전자 우편";
var xmsgRegmethod10NSA=		"아래 표시된 사용자 등록 및 라이센스 서버 정보가 " +
							"자동으로 파일에 저장되었습니다.";
var xmsgRegmethod10=		"등록 정보가 다음 파일에 저장되었습니다. "+
							"이 파일은 전자 우편 프로세스를 완료하는 데 사용되므로 수정하지 마십시오.";
var xmsgRegmethod11NSA=		"전자 우편으로 등록 및 라이센스 서버 정보 파일 %1을(를) %2(으)로 보내십시오.";
var xmsgRegmethod11=		"전자 우편으로 등록 정보 파일 %1을(를) %2(으)로 보내십시오.";
var xmsgRegmethod12=		"파일을 수정하지 마십시오.<p>" +
							"이 페이지의 사본을 인쇄하여 안전한 곳에 보관하는 것이 " +
							"좋습니다. 수동으로 전자 우편 처리를 완료하려면 이 정보가 "+
							"필요합니다.<p>" +
							"이 정보의 사본을 사용자 기록용으로 인쇄할 수 있습니다. 응용프로그램을 " +
							"닫으려면 종료를 클릭하십시오.";
var xmsgRegmethod13=		"%1을(를) 자동으로 첨부하여 Autodesk로 보내려면 아래 링크를 클릭하십시오.";
var xmsgRegmethod14=		"전자 우편으로 내 요청 보내기";
var xmsgRegmethod15=		"주: 전자 우편 주소는 자동으로 처리됩니다. 이 주소로 전자 우편을 보내지 마십시오.";
var xmsgRegmethod16=		"팩스나 우편으로 등록하려면 다음 링크 중 하나를 클릭하십시오.";
var xmsgRegmethod17=		"전자 우편을 보내는 중 오류가 발생했습니다";
var xmsgRegmethod18NSA=		"시스템이 자동으로 등록 및 라이센스 서버 정보를 보내는 중 오류가 발생했습니다.";
var xmsgRegmethod18=		"시스템이 자동으로 등록 정보를 보내는 중 오류가 발생했습니다.";
var xmsgRegmethod19=		"전자 우편으로 파일을 수동으로 보내려면:";
var xmsgRegmethod20NSA=		"전자 우편으로 등록 및 라이센스 서버 정보 파일 %1을(를) %2(으)로 보내십시오.";
var xmsgRegmethod20=		"전자 우편으로 등록 정보 파일 %1을(를) %2(으)로 보내십시오.";
var xmsgRegmethod21=		"파일을 수정하지 마십시오.<p>" +
							"이 페이지의 사본을 인쇄하여 안전한 곳에 보관하는 것이 좋습니다. " +
							"수동으로 전자 우편 처리를 완료하려면 이 정보가 필요합니다.<p>" +
							"이 정보의 사본을 사용자 기록용으로 인쇄할 수 있습니다. 응용프로그램을 "+
							"닫으려면 종료를 클릭하십시오.";
var xmsgRegAuthInfo=		"제품 라이센스 활성화 옵션";
var xmsgRegAuthInfo1=		"등록 확인";
var xmsgRegExpConfirm=      "라이센스 내보내기 확인";
var xmsgRegImpConfirm=      "라이센스 가져오기 확인";
var xmsgRegAuthInfo2 =      "지금 연결 및 활성화! (권장)";
var xmsgRegAuthInfo2Hover = "Autodesk에 연결하여 제품 라이센스 즉시 활성화(인터넷 연결 필요)";
var xmsgRegAuthInfo3=		"활성화 코드 입력"; 
var xmsgRegAuthInfo4=		"다음에서 옵션 선택:";
var xmsgRegAuthInfo4A =     "Autodesk에서 받은 활성화 코드가 있습니다.";
var xmsgRegAuthInfo4AHoverA = "Autodesk에 요청하여 받은 활성화 코드를 입력합니다.<br>이 단계를 간단히 끝내려면 첫 번째 상자에 활성화 코드 전체를 붙여 넣으십시오. 나머지 상자에는 자동으로 값이 채워집니다.";
var xmsgRegAuthInfo4AHoverB = "파일 경로와 이름을 입력하거나, Autodesk에 전자 우편으로 요청하여 받은 활성화 파일을 찾습니다.";
var xmsgRegAuthInfo4B=		"활성화 코드 입력:"; 
var xmsgRegAuthInfo5=		"국가 또는 지역을 선택하고 활성화 코드를 입력한 후 다음 버튼을 클릭하십시오.";
var xmsgRegAuthInfo6=		"제품 라이센스 활성화";	
var xmsgRegAuthInfo7=		"%1이(가) 활성화되었습니다.";
var xmsgRegAuthInfo8=		"확인";		
var xmsgRegAuthInfo9=		"Autodesk 제품을 등록해 주셔서 감사합니다. 앞으로 여러분께 보다 나은 서비스를 제공하는 데 도움이 될 것입니다.";
var xmsgRegAuthInfo10=		"활성화 정보의 복사본 저장 위치:";		
var xmsgRegAuthInfo10B=		"활성화 정보의 복사본 저장 위치:";
var xmsgRegAuthInfo14=		"%1을(를) 구입해 주셔서 감사합니다. 활성화된 라이센스 조건에 따라 하나 이상의 제품을 사용자 컴퓨터에서 실행할 수 있습니다.";
var xmsgRegAuthInfo15=		"%1을(를) 설치제거해도 라이센스는 제거되지 않습니다.";
var xmsgRegAuthInfo16=		"활성 라이센스";
var xmsgRegActLicInfo=      "활성화된 라이센스 발견";
var xmsgRegActLicInfoError=      "등록 - 활성화 오류";
var xmsgRegActiveInfo=        "활성화 파일을 입력하거나 활성화 파일을 찾습니다.";
var xmsgRegActLicInfo1=       "이전에 등록 및 활성화한 제품 라이센스가 이 컴퓨터에 있으며 현재 사용 중입니다."
var xmsgRegActLicInfo1Error= "이전에 등록 및 활성화한 제품 라이센스가 이 컴퓨터에 있습니다.\n그러나 예상치 못한 오류(%1)가 발생했습니다. 응용프로그램을 닫고 다시 시도하십시오. 이 문제가 지속되면 시스템 관리자나 공인 Autodesk 제품 딜러에게 문의하십시오.";

/////////////////////////////////////////////
// OLT Confirmation
/////////////////////////////////////////////
var xmsgExportSuccess=        "내보내기 성공"; //2008-01-16
var xmsgExportFail=           "내보내기 요청 실패" ; //2008-01-16
var xmsgRegErrRef=            "오류 참조:"; //2008-01-17
var xmsgImportSuccess=        "가져오기 성공"; //2008-01-16
var xmsgImportFail=           "가져오기 요청 실패"; //2008-01-16
var xmsgExpSucessInfo=        "라이센스를 내보냈으며 현재 라이센스는 Autodesk 서버에 있습니다."; //2008-01-16
var xmsgExpSuccessInfoHowtoImport=    "라이센스를 가져오는 방법";
var xmsgExpSucessInfo1=        "대상 컴퓨터에서 제품을 시작하기 전에, 라이센스 전송 유틸리티를 사용하여 이 라이센스를 해당 컴퓨터로 가져온 다음 Autodesk 사용자 ID와 암호를 입력할 수 있도록 준비합니다.";  //2008-01-16
var xmsgImpSucessInfo=         "라이센스를 가져왔습니다. 이제 이 제품을 사용하실 수 있습니다. "; //2008-01-16
var xmsgImpRemindInfo=         "내보내야 할 때 알려 주십시오."; //2008-01-16
var xmsgImpRemindInfo1=        "이 확인란을 선택하면 종료할 때마다 라이센스를 내보내라고 알려 주는 대화상자가 나타납니다.";//copy mockup 2008-01-16
var xmsgImpRemindInfo2=        "이 기능은 라이센스를 임시로 이 컴퓨터로 가져왔다가 다시 전송해야 하는 경우에 유용합니다.";//copy mockup 2008-01-16
var xmsgImpRemindInfo3=        "확인 메시지에서 \"다시 표시 안함\" 옵션을 사용할 수 있습니다.";//copy mockup 2008-01-16
var xmsgOltTryAgain=           "요청을 다시 제출하려면 \"다시 시도\" 링크를 클릭하십시오. ";
var xmsgImpFailMsg=            "문제가 지속되면 라이센스를 가져오는 대신 활성화해야 합니다.";

var xmsgReqfilelocMsg=       "요청 파일 위치:";	//add by joyce.min on 2007-9-10 as Licensing Spec. recommend 	
var xmsgRegAuthInfo11=		"등록해 주셔서 감사합니다. 제품이 활성화되었으며 라이센스 파일이 저장되었습니다. "+
							"이 정보를 보관해 두려면 인쇄를 클릭하십시오.";
var xmsgRegAuthInfo12=		"활성화 코드를 붙여 넣으십시오.";
var xmsgRegAuthInfo13=		"활성화 코드를 입력하십시오.";
var xmsgRegErrorActiveCode=    "<FONT color=red>계속하려면 활성화 코드를 입력하십시오.</FONT>";
var xmsgRegErrorActiveCode1=    "<FONT color=red>활성화 코드가 유효하지 않습니다. 코드에 오류가 있는지 확인하십시오.</FONT>";
var xmsgRegErrorActiveFile=    "<FONT color=red>계속하려면 활성화 파일의 경로와 이름을 입력하십시오.</FONT>";
var xmsgRegErrorSernum=      "<FONT color=red>계속하려면 일련 번호를 입력하십시오.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorSernum1=      "<FONT color=red>일련 번호가 너무 짧습니다.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorProkey=      "<FONT color=red>계속하려면 제품 키를 입력하십시오.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorProkey1=     "<FONT color=red>제품 키가 너무 짧습니다.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorHdr=		"등록 - 활성화 오류";
var xmsgRegErrorSystem=		"일시적인 시스템 문제로 인해 등록 오류가 발생했습니다. "+
							"다음 링크 중 하나를 클릭하십시오."
var xmsgRegErrorPrevReg=	"입력하신 일련 번호는 이미 등록되어 있습니다.";
var xmsgRegErrorMaxAuth=	"이 제품에 허용되는 활성화 횟수를 초과했습니다.";
var xmsgRegErrorMaxAuth2=	"이 제품에 허용되는 라이센스 수를 초과했습니다.";
var xmsgRegErrorInvalidOld=	"입력한 이전 제품의 일련 번호가 유효하지 않습니다. 위에 표시된 "+
							"이전 일련 번호가 올바른지 확인하십시오. " +
							"다음 링크 중 하나를 클릭하십시오.";
var xmsgRegErrorData=		"입력한 등록 데이터에 문제가 있습니다. 다시 시도를 선택하여 " +
							"입력한 정보를 검토 및 수정하거나, 다른 방법으로 등록하거나, " +
							"Autodesk에 문의하여 계속할 수 있습니다.";
var xmsgRegErrorNetwork=	"현재 등록하려는 제품은 네트워크 권한이 부여된 제품이므로 이에 따라 " +
                            "설치해야 합니다. 소프트웨어를 제거하고 설치 유형으로 " +
                            "\"네트워크\"를 선택하십시오.<p>네트워크 버전의 올바른 설치 및 활성화 " +
                            "절차는 설치 안내서의 네트워크 설치 단원을 참조하십시오." +
                            "";
var xmsgRegNoResponse=		"일시적인 문제로 인해 온라인 등록 오류가 발생했습니다. " +
							"다음 링크 중 하나를 클릭하십시오.";
var xmsgRegErrorAuthEntry=	"입력한 활성화 코드에 문제가 있습니다. " +
							"다음 링크 중 하나를 클릭하십시오.";
var xmsgRegErrorAuthPermission = "이 Autodesk 제품을 활성화하려면 관리자 권한이 있거나 " +
                            "시스템 관리자로부터 권한 승급을 받아야 합니다. "+
                            "관리자 및 권한 승급에 대한 자세한 내용은 시스템 관리자에게 문의하십시오.";							
var xmsgRegErrorAuth=		"활성화 코드에 문제가 있습니다. 다음 링크 중 하나를 클릭하십시오.";
var xmsgRegErrorFlex=		"라이센스에 문제가 있습니다. 다음 링크 중 하나를 클릭하십시오.";
var xmsgRegConnError=		"연결 오류";
var xmsgRegConnErrorTxt=	"인터넷 연결에 문제가 있습니다. 다음 링크 중 하나를 클릭하십시오.";
var xmsgRegPurchError3=		"다른 구매 방법을 사용하십시오";
//modified as LFSpec_SCV commend by joyce.min
var xmsgRegPurchError5=		 "Autodesk 소프트웨어를 선택해 주셔서 감사합니다.<p>현재 이 과정을 완료하기 위한 " +
							"연결이 되지 않고 있습니다. 사용자 시스템의 설정 때문인 것으로 생각됩니다.<p>아래 링크 중 " +
							"하나를 클릭하면 브라우저가 열리고 다시 연결할 수 있게 됩니다.<p>";

var xmsgAuthResellerMsg1=	"해당 지역 리셀러에게서 구입하십시오. 구입을 완료하려면 해당 지역 리셀러에게 문의하십시오.";

var xmsgLicSaveErrInfo=		"라이센스 파일을 저장하는 중 오류가 발생했습니다. 다음 링크 중 하나를 클릭하십시오.";

var xmsgOnlineStoreMsg1=	"Autodesk 온라인 상점에서 구입하십시오. 원하는 제품이 온라인 상점에 없는 경우, " +
							"공인 리셀러에게 문의하십시오.";
var xmsgOnlineStoreMsg2=    "온라인 상점";
var xmsgAuthResellerMsg2=	"공인 리셀러";
var xmsgLocateLicenseMsg1=	"라이센스 파일 찾기";
var xmsgLocateLicenseMsg2=	"라이센스 파일의 경로를 입력하거나 찾아보기로 경로를 찾은 뒤 " +
							"다음을 클릭하여 계속하십시오.";
var xmsgLocateLicenseMsg3=	"기존 라이센스 파일:";
var xmsgUserContactMsg=		"다음 중 하나 이상을 입력해야 합니다.";
var xmsgFailureMsg=		    "온라인 활성화 요청을 처리할 수 없습니다.";

/////////////////////////////////////////////
// Default Ereg returned error messages
/////////////////////////////////////////////
var xmsgDefaultEregReturnedErrMsg=  "온라인 활성 요청에 대해 오류(%1)가 반환되었습니다. " +
                            "자동화 시스템을 사용하여 요청을 처리할 수 없습니다. " +
                            "";
var xmsgRegErrorOnline=		"아래의 \"다른 방법 사용\" 링크를 클릭하여 필요한 양식을 "+
                            "작성하고 해당 지역의 Autodesk Business Center에 "+
                            "요청을 제출하십시오. 고객 서비스 담당자가 "+
                            "영업일 기준으로 2일 이내에 연락을 드릴 것입니다.";
var xmsgAnotherFormSubmitMethod=    "다른 방법 사용";
var xmsgOfflineRegistrationMethod=    "오프라인으로 활성화 코드 요청";
var xmsgOfflineRegistrationMethodHover= "해당 제품 라이센스에 대한 활성화 코드 요청을 작성한 다음 전자 우편이나 전화 또는 팩스로 Autodesk에 보냅니다.";

/////////////////////////////////////////////
// Timeout message
/////////////////////////////////////////////
var xmsgTimeoutMsg1=    "온라인 활성화 요청이 시간 종료되었습니다."
var xmsgTimeoutMsg2=    "\"다시 시도\" 링크를 클릭하여 온라인 요청을 다시 제출하십시오. "+
                        "문제가 지속되면 \"다른 방법 사용\" 링크를 클릭하여 "+
                        "필요한 양식을 작성하고 전자 우편, 팩스 또는 다른 방법으로 "+
                        "요청을 제출할 수 있습니다.";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"등록 데이터가 저장되었습니다";
var xmsgRegSunData2=		"클라이언트 배치에 필요한 등록 데이터 저장 위치: ";
var xmsgRegSunData3=		"이 업그레이드의 등록을 위해 제공한 이전 일련 번호가 유효하지 않습니다. 관리자에게 문의하십시오.";
var xmsgRegSunData4=		"유효한 이전 일련 번호를 사용하여 이 소프트웨어를 다시 설치해야 합니다.";
var xmsgRegSunData5=		"다중 시트 독립 실행형 배치";
var xmsgRegSunData6=		"다중 시트 독립 실행형 배치를 완료하려면 일부 등록 정보가 필요합니다. 다음 페이지에서,";
var xmsgRegSunData7=		"필요한 정보를 수집할 것입니다.";
var xmsgRegSunData8=		"업그레이드에 필요할 경우 이전 일련 번호의 입력을 허용합니다.";
var xmsgRegSunData9=		"설치된 모든 클라이언트에 배치하기 위해 이 정보를 서버에 저장합니다.";
var xmsgRegSunData10=		"다음 정보를 사용하여 이 소프트웨어를 등록합니다. 계속 진행하려면 다음 버튼을 클릭하십시오.";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"제품 등록";
var xmsgRegVol2=	"옵션을 선택한 후 다음을 클릭합니다.";
var xmsgRegVol3=	"지금 등록 - 온라인 등록을 시작하려면 이 옵션을 선택하십시오";
var xmsgRegVol4=	"나중에 등록 - 지금 소프트웨어를 실행하려면 이 옵션을 선택하십시오";
var xmsgRegVol5=	"이 메시지를 다시 표시하지 않음.";
var xmsgRegVol6=	"(나중에 등록하려면 도움말|정보 대화상자에서 등록 옵션을 선택하면 됩니다.)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"사용자 ID";
var xmsgKatakana=		    "회사명(젠카쿠 카나):";
var xmsgDepartment=		    "부서:";
var xmsgDepartment2=		"부서명:";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"인터넷:";
var xmsgFormWebDataMsg1 = "다음을 방문하여 활성화 코드를 요청할 수도 있습니다.&nbsp;&nbsp;";
var xmsgFormEmailHdr=	"전자 우편:";
var xmsgFormEmailData=	"";
var xmsgFormEmailDataBlock= "";
var xmsgFormEmailXMLData=	"";
var xmsgFormEmailXMLDataBlock= "";
var xmsgFormFaxHdr=		"팩스 번호:";
var xmsgFormFaxHdrLocal=	"팩스(지역 사무소):";
var xmsgFormFaxHdrReg=	"팩스(등록):";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"전화 번호:";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"우편 메일:";
var xmsgFormMailHdrLocal=	"우편(지역 사무소):";
var xmsgFormMailHdrReg=	"우편(등록):";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"소프트웨어 구매";
var xmsgFormInternetMsg=    "웹 브라우저를 사용하여 활성화 코드를 요청하려면 링크를 클릭하십시오."
var xmsgFormEmailMsg=       "전자 우편을 사용하여 서신 및 활성화 요청을 다음 주소로 보내기:"

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var JPprivacystatement = "제공하신 정보는 Autodesk에서 활성화 코드를 등록 및/또는 발급하는 데 " +
			"사용됩니다. 등록을 하면 제품 라이센스 관리 및 권한 확인 목적으로 " +
			"Autodesk가 공인 비즈니스 파트너에게 사용자 정보를 제공할 수 있다는 데 " +
			"동의하게 됩니다. 이러한 제한된 목적의 정보 공유를 원치 않는 경우, " +
			"<a href=mailto:information@autodesk.jp target=\"_blank\">information@autodesk.jp</a> " +
			"주소로 Autodesk에 알려 주십시오. " +
			"등록 데이터를 수정하거나 업데이트하는 방법은 "+
			"<a %1>여기</a>를 " +
			"클릭하여 Autodesk에 문의하거나 해당 지역의 Autodesk 사무소에 문의하십시오.";
			
var privacystatement = "제공하신 정보는 Autodesk에서 활성화 코드를 등록 및/또는 발급하고, " +
			"제품과 서비스에 대한 최신 정보를 제공하고, 공인 Autodesk 사용자를 위한 혜택을 보장하는 데 " +
			"사용됩니다. Autodesk는 사용자 정보를 판매하거나 Autodesk 또는 공인 비즈니스 파트너 이외의 다른 사람에게 " +
			"사용자 정보를 제공하지 않습니다. 이전에 등록한 고객 정보를 " +
			"수정하거나 업데이트하는 방법은 " +
			"<a %1>여기</a>를 " +
			"클릭하여 Autodesk에 문의하거나 해당 지역의 Autodesk 사무소에 문의하십시오.";
				
			
/////////////////////////////////////////////
// Privacy Policy
/////////////////////////////////////////////
var xmsgPrivacyPolicy="개인 정보 보호 정책";

/////////////////////////////////////////////
// Copyright
/////////////////////////////////////////////
var xmsgCopyright="(c) Copyright 2009 Autodesk, Inc. All rights reserved."; //modify by joyce.min on 2007-8-14

/////////////////////////////////////////////
// Rebranding Message
/////////////////////////////////////////////
var xmsgRebranding="대부분의 경우, 프로그램을 닫은 후 관리자 권한으로 다시 시작해야 "+ 
                   "새 일련 번호가 표시됩니다.";
var xmsgRebranding2="관리자 권한으로 프로그램을 시작하는 방법은 해당 운영 체제의 설명서를 참조하십시오.";
/////////////////////////////////////////////
//  Note to Localization :
//
//	"InsertRegInfo" appears in RTUserInfo.html.  The full sentence in English is
//
//	"Fields marked in <FONT color=red>red</FONT> and with an asterisk (<FONT 
//	color=red>*</FONT>) are required to process your registration. Complete the form 
//	and click Next."
//
/////////////////////////////////////////////
var xmsgRegInfoMsg1= "<FONT color=red>*</FONT>로 표시된 필드는 필수 필드입니다.";
var xmsgRegInfoMsg2= "이 페이지에 입력한 정보는 사용자 라이센스와 함께 저장되며 "+
					 "제품을 다시 활성화하고 업그레이드하는 데 사용됩니다. "+
					 "지연 없이 제품을 사용하려면 여기에 올바른 정보를 입력하십시오.";

var xmsgLicLocationText1 = "<b>%1</b> 라이센스 파일의 저장 위치:";

// Set Registration Info Header
var InsertRegInfo =     "<p><b>"+xmsgRegInfo+"</b></p>" +
			  "<p>" + xmsgRegInfoMsg1 + "</p>";


//=======================================================================
// Application Usage Information
//=======================================================================
var xmsgAppUsage=	"질문:";

var xmsgAppUsageQ1=	"Autodesk가 해당 업종의 요구사항을 보다 잘 이해할 수 있도록 "+
					"다음 질문에 답변해 주십시오.";
var xmsgAppUsageQ2=	"다음 중 해당 업종에 가장 적합한 설명은 무엇입니까?";

var xmsgAppUsageOption51=	"항공우주 및 자동차 부품 설계 ";
var xmsgAppUsageOption52=	"건축 설계 ";
var xmsgAppUsageOption53=	"건물 및 공장 관리 ";
var xmsgAppUsageOption54=	"건물 건축: 상업용 ";
var xmsgAppUsageOption55=	"건물 건축: 주거용 ";
var xmsgAppUsageOption56=	"건설 장비 제조 ";
var xmsgAppUsageOption57=	"토목 엔지니어링/토지 계획 ";
var xmsgAppUsageOption58=	"컴퓨터/의료/사무용 기기 설계 ";
var xmsgAppUsageOption67=	"소비자 제품 설계 ";
var xmsgAppUsageOption59=	"회사 건물 소유권 ";
var xmsgAppUsageOption92=	"방위 산업 ";
var xmsgAppUsageOption93=	"전기 제어 설계 ";
var xmsgAppUsageOption94=	"전기 시스템 엔지니어링 ";
var xmsgAppUsageOption72=	"환경 엔지니어링 ";
var xmsgAppUsageOption95=	"가공 금속 제품 ";
var xmsgAppUsageOption96=	"인테리어 디자인 ";
var xmsgAppUsageOption97=	"기계 설계 ";
var xmsgAppUsageOption98=	"제조 조달/판매/마케팅 ";
var xmsgAppUsageOption40=	"지도 제작 및 지리 공간 설계 ";
var xmsgAppUsageOption41=	"기계 시스템 엔지니어링(HVAC 및 배관) ";
var xmsgAppUsageOption42=	"배관 및/또는 화재 방지 시스템 엔지니어링 ";
var xmsgAppUsageOption43=	"프로세스 및 발전소 설계 ";
var xmsgAppUsageOption44=	"부동산 개발 ";
var xmsgAppUsageOption45=	"구조 엔지니어링 ";
var xmsgAppUsageOption87=	"텔레커뮤니케이션 ";
var xmsgAppUsageOption46=	"공구 및 염색/철공 ";
var xmsgAppUsageOption47=	"운송 설계 ";
var xmsgAppUsageOption48=	"공공 시설: 전기, 유류 및 가스 ";
var xmsgAppUsageOption49=	"공공 시설: 수도 및 하수구 ";
var xmsgAppUsageOption99=	"기타 ";

var xmsgWrongCountryCodeMsg=	"오류: 알 수 없는 국가 코드를 입력했습니다.";

/////////////////////////////////////////////
// Version RESOURCES HERE:
/////////////////////////////////////////////
var xmsgVersion = "버전:"

/////////////////////////////////////////////
// Access RTFax or RTMail through RTEmail
/////////////////////////////////////////////
var xmsgAccessFaxMsg=		"요청을 팩스 또는 전화로 보냅니다"; //modify by joyce.min on 2007-10-18 as Licensing_Framework Spec_Frozen.doc recommend 
var xmsgAccessMailMsg=		"전자 우편으로 등록합니다.";
var xmsgAccessHereMsg=		"여기";

/////////////////////////////////////////////
// Receive code by
/////////////////////////////////////////////
var xmsgReceiveCodeMsg=     "코드 획득 방법:";
var xmsgReceiveCodeMsg1=     "활성화 파일을 전자 우편으로 받겠습니다."; //add by joyce.min on 2007-8-20
/////////////////////////////////////////////
// Messages for Ease of reauth or multi-seat client registration
/////////////////////////////////////////////
var xmsgNoDialogHdrMsg=		"라이센스를 검증하는 동안 <br>기다려 주십시오";
/////////////////////////////////////////////
//Resource for RTProductInfo
/////////////////////////////////////////////
var xmsgRTProductInfoTitle=      "제품 정보 필요"; //add by joyce.min on 2007-8-14
var xmsgRTProductInfoMsg1=        "%1 라이센스를 활성화하려면 제품 포장 또는 Autodesk 업그레이드 및 라이센싱 정보 전자 우편에 \"있는 일련 번호와 제품 키를 입력하십시오.\"";
/////////////////////////////////////////////
//Error for RTProductInfo
/////////////////////////////////////////////
//var xmsgsernumError=        "Enter a serial number to proceed."; //add by joyce.min on 2007-8-17
//var xmsgprokeyError=        "Enter a product key to proceed." ; //add by joyce.min on 2007-8-17
/////////////////////////////////////////////
// Resource for NSA_RTBegin.html
/////////////////////////////////////////////
var xmsgNSARTBeginTitle=	"네트워크 라이센스 받기";
var xmsgNSARTBeginMsg1=		"네트워크 라이센스 활성화 파일 요청 방법:";
var xmsgNSARTBeginMsg2=		"직접 연결(인터넷)";
var xmsgNSARTBeginMsg3=		"전자 우편, 팩스 또는 전화로 요청을 보냅니다";
var xmsgNSARTBeginNoInternet=	"";

/////////////////////////////////////////////
// Edit server and seat information
/////////////////////////////////////////////
var xmsgEditServerHdrMsg1=	"서버 정보";
var xmsgEditServerHdrMsg2=	"라이센스 서버 모델*";
var xmsgEditServerMsg1=		"라이센스 서버 정보를 입력하십시오.<br>"+
							"찾기 버튼을 클릭하여 서버 호스트 ID 필드에 값을 채우십시오.<p>";
var xmsgEditServerMsg2=		"기존 라이센스 파일의 서버 호스트 데이터로 시작하십시오.";
var xmsgEditServerRemove=	"제거";
var xmsgEditServerHostName=	"서버 호스트 이름*";
var xmsgEditServerHostID=	"호스트 ID*";
var xmsgEditServerSeat=		"시트*";
var xmsgEditServerSingle=	"단일 서버";
var xmsgEditServerDistributed=	"분산 서버";
var xmsgEditServerRedundant=	"중복 서버";
var xmsgEditServerDots=		"...";
var xmsgEditServerLookup=	"찾기";
var xmsgEditServerAddServer=	"추가";
var xmsgEditServerRemoveServer=	"제거";
var xmsgEditServerTotal=	"전체:";
var xmsgEditServerExceedMaxServer=	"주: 최대 20개의 분산 서버에 동시에 라이센스를 부여할 수 있습니다. 21개 이상의 서버 라이센스가 필요한 경우, "+
									"Autodesk에 문의하십시오.";
var xmsgEditServerSeatError=	"시트에는 숫자 값만 포함되어야 합니다.";

var xmsgConfirmServerMsg=	"다음 정보를 검토하십시오. 계속하려면 다음 버튼을 클릭하고, 변경하려면 뒤로 버튼을 클릭하십시오.";
var xmsgConfirmServerMsg2=	"다음을 클릭하면 이 정보가 인터넷을 통해서 Autodesk로 전송됩니다.";
var xmsgConfirmServerHdr2=	"라이센스 서버 모델:";
var xmsgConfirmServerHostName=	"서버 호스트 이름";
var xmsgConfirmServerHostID=	"호스트 ID";
var xmsgConfirmServerSeat=		"시트";
var xmsgConfirmServerTotal=		"전체 시트:";

var xmsgLicErrorHdr=			"라이센스 부여 오류"; 
var xmsgLicErrorInvalidSN=		"입력한 일련 번호가 유효하지 않습니다. 위에 표시된 일련 번호가 "+
								"올바른지 확인하고 다음 링크 중 하나를 클릭하십시오.";
var xmsgLicReEnterSN=			"일련 번호를 재입력하고 다시 시도하십시오.";

var xmsgLic113Msg2=				"분산 서버에 할당한 총 시트 수가 해당 숫자를 초과합니다.";
var xmsgLic113ModifySeats=		"시트 분배를 수정하십시오.";

var xmsgSaveLicenseHdr=			"받은 라이센스 수";
var xmsgSaveLicenseMsg1=		"Autodesk로부터 라이센스를 받았습니다. 이 라이센스를 파일로 저장해야 합니다.<p> " +
								"<b>라이센스를 라이센스 파일로 저장</b><p>" +
								"<LI>라이센스 파일의 <b>권장 위치</b>는 Autodesk Network License Manager가 " +
								"설치된 서버의 \"License\" 디렉토리입니다.&nbsp;&nbsp;";
var xmsgSaveLicenseMsg6=		"<LI><b>기존 라이센스 파일</b>이 있다면 새 라이센스를 기존 파일에 <b>삽입</b>하십시오.<br>" +
								"다음을 클릭하면 라이센스 정보가 기존 파일의 적당한 위치에 " +
								"자동으로 삽입됩니다.</LI>";
var xmsgSaveLicenseMsg2=		"위에서 지정한 파일이 기존 라이센스 파일인 경우:";
var xmsgSaveLicenseMsg3=		"새 라이센스 정보를 기존 파일에 삽입합니다.";
var xmsgSaveLicenseMsg4=		"기존 라이센스 파일을 덮어씁니다.";
var xmsgSaveLicenseMsg5=		"다음 오류를 수정하십시오.";

var xmsgSaveErrorFileNameTooLong=  "오류: 입력한 파일 이름이 너무 깁니다.<br>" +
								"파일 이름을 변경하고 계속하십시오.";
var xmsgSaveErrorNoPermission=	"오류: 지정한 위치에 파일을 저장할 권한이 없습니다.<br>" +
								"파일을 임시 위치에 저장하고 적당한 권한을 받은 뒤 해당 위치로 파일을 이동하십시오.";
var xmsgSaveErrorNoDiskSpace=	"오류: 지정한 위치에 파일을 저장하기에는 디스크 공간이 " +
								"부족합니다.<BR>파일을 임시 위치에 저장하고 디스크 공간을 추가로 확보한 뒤 파일을 이동하십시오.";
var xmsgSaveErrorInvalidFile=	"오류: 새 라이센스를 지정한 파일에 추가하려면 데이터 손실을 피할 수 없습니다. " +
								"다른 컴퓨터용 파일이나 다른 서버 모델용 파일을 지정했을 수 있습니다.<BR>" +
								"새 라이센스 파일을 다른 이름 또는 다른 위치로 저장한 뒤 나중에 수동으로 파일에 추가하십시오.";															
var xmsgSaveErrorPathNotExit=	"오류: 지정한 경로가 없습니다.<BR>찾아보기 버튼을 클릭하여 찾거나 경로를 작성하십시오.";
var xmsgSaveErrorPathBlank=		"오류: 유효한 경로와 라이센스 파일 이름을 지정해야 합니다. 아래 필드에 " +
								"경로와 파일 이름을 지정하거나 찾아보기로 찾으십시오.";

var xmsgLicAuthConfirmHdr1=		"라이센스를 활성화했습니다!";
var xmsgLicAuthConfirmHdr2=		"라이센스 서버 호스트 정보";
var xmsgLicAuthConfirmMsg1=		"제품을 등록해 주셔서 감사합니다. 이 정보의 기록을 인쇄할 수 있습니다.";
var xmsgLicAuthConfirmDate=		"날짜:";

var xmsgLicPathMsg1=			"저장된 라이센스 파일:";
var xmsgLicPathMsg2=			"라이센스 파일 저장 위치:";

var xmsgOtherMethodMsg1NSA=		"다른 방법을 사용하여 권한 부여된 라이센스를 받으십시오.";
var xmsgOtherMethodMsg1=		"다른 방법을 사용하십시오.";

var xmsgContactAutodeskMsg1=	"다음 방법 중 하나를 사용하여 Autodesk에 문의하십시오.";
								
/////////////////////////////////////////////
// Email Options
/////////////////////////////////////////////
var xmsgEmailOptionNSATitle=	"전자 우편으로 라이센스 파일 받기";
var xmsgEmailOptionTitle=		"전자 우편으로 등록";
var xmsgEmailOptionNSAMsg=		"등록 정보 및 라이센스 서버 정보가 자동으로 파일에 저장되었습니다. " +
								"이 파일을 전자 우편으로 Autodesk 자동 등록 처리 센터에 " +
								"보내야 합니다.<p>파일을 전자 우편으로 Autodesk에 보내면 자동 응답 메시지와 함께 " +
								"공인 라이센스 파일 및 처리 완료 방법에 대한 지침을 " +
								"받게 됩니다.";
var xmsgEmailOptionMsg=			"등록 정보가 자동으로 파일에 저장되었습니다. 이 파일을 전자 우편으로 " +
								"Autodesk 자동 등록 처리 센터에 보내야 합니다.<p>파일을 전자 우편으로 " +
								"Autodesk에 보내면 자동 응답 메시지와 함께 처리 완료 방법에 대한 지침을 " +
								"받게 됩니다.";
var xmsgEmailOptionMsg2=		"사용 중인 기본 전자 우편 시스템에 인터넷으로 전자 우편을 보내는 기능이 있다면 " +
								"지금 파일 보내기를 클릭하고 다음을 클릭합니다. 그러면 파일이 자동으로 전송됩니다.<p>" +
								"지금 인터넷으로 전자 우편을 보낼 수 없는 경우 나중에 파일 보내기를 클릭합니다. 파일을 수동으로 보내는 " +
								"방법이 표시됩니다.";
var xmsgEmailOptionInfo1=		"지금 파일을 보냅니다.";
var xmsgEmailOptionInfo2=		"나중에 파일을 수동으로 보냅니다.";
var xmsgEmailOptionInfo3=		"제공한 전자 우편 주소로 전자 우편 사본을 보냅니다.";

/////////////////////////////////////////////
// Email Error
/////////////////////////////////////////////
var xmsgEmailErrorHdr=			"전자 우편을 작성할 수 없습니다";
var xmsgEmailErrorMsg1=			"전자 우편으로 등록을 완료하려면 다음 파일을 전자 우편에 첨부하십시오.";
var xmsgEmailErrorMsg2=			"전자 우편을 %1(으)로 보냅니다.";
var xmsgEmailErrorMsg3=			"파일 위치:";

/////////////////////////////////////////////
// Local HERE customer information URLs
/////////////////////////////////////////////
var xmsgLocalHERETitle=			"고객 정보 변경";
var xmsgLocalHEREInfo=			"고객 정보를 변경하려면 Autodesk 공인 리셀러에게 문의하거나 " +
								"아래에서 해당 국가 또는 지역의 링크를 클릭하십시오.";
var xmsgLocalHEREUS=			"아메리카";
var xmsgLocalHEREEMEA=			"유럽, 중동, 아프리카";
var xmsgLocalHEREAPAC=			"아시아/태평양";

/////////////////////////////////////////////
// Help
/////////////////////////////////////////////
var xmsgHelpTitle=				"도움말";
var xmsgHelpUpgradeMsg=			"이전 버전에서 업그레이드한 제품을 등록 또는 활성화하는 경우 이 확인란을 "+
								"클릭해야 합니다. 그러면 업그레이드하기 이전 버전의 "+
								"일련 번호를 묻는 메시지가 나타납니다.";
var xmsgHelpUpgradeRequiredTitle=	"업그레이드를 위해 이전 제품의 일련 번호를 입력합니다.";
var xmsgHelpUpgradeRequiredMsg=	"이전 소프트웨어 버전의 일련 번호입니다. 소프트웨어의 도움말 > 정보 "+
								"대화상자나 이전 제품의 포장 상자에서 일련 번호를 "+
								"확인할 수 있습니다.";

//	Fax or email error message
var xmsgNotEnterErrorMsg=		"%1을(를) 입력하지 않았습니다. 이 방법으로 활성화 코드를 받으려면 %1을(를) 입력하십시오.";								

//  Help for serial number
var xmsgHelpSerialNumberTitle=  "일련 번호"; ////modify by joyce.min on 2007-8-16
var xmsgHelpSerialNumberMsg=    "일련 번호는 제품 포장 상자나 Autodesk 업그레이드 및 라이센싱 정보 전자 우편에 나와 있습니다."; // ECO19

//  Help for ProductInfo serial number & Product Key //modify by joyce.min on 2007-8-16
var xmsgHelpProductKeyTitle=   "제품 키";
var xmsgHelpProductKeyMsg=    "제품 키는 제품 포장의 일련 번호 근처에 표시되어 있거나 Autodesk 업그레이드 및 라이센싱 정보 전자 우편에 나와 있습니다."; // ECO19

/////////////////////////////////////////////
// The following strings are added back for backward competibility reason
/////////////////////////////////////////////
var xmsgRT0015TempSysErr=				"연결 오류(0.15)";
var xmsgRT010203071213CannotCompErrA=	"등록 오류(1.2.3.7.12.13)";
var xmsgRT09AlreadyReg=					"이미 등록됨(9)";
var xmsgRT10ExceededAuths=				"권한 초과(10)";
var xmsgRT12StolenSN=					"도난된 일련 번호(12)";
var xmsgRT18OldSNInvalid=				"유효하지 않은 이전 일련 번호(18)";
var xmsgRT20DataError=					"데이터 오류(20)";
var xmsgRT21CustIDTelErr=				"고객 ID/전화 번호 오류(21)";
var xmsgRT22NetworkInstallation=		"네트워크 설치 오류(22)";
var xmsgRT900SystemNotResponding=		"시스템 무응답(900)";
var xmsgRTCustID=						"고객 ID";
var xmsgRTCustIDConfirm=				"ID 확인";
var xmsgRTNewSerialNumber=				"새 일련 번호 정보";
var xmsgRTNoNewSN=						"구매 트랜잭션 오류";
var xmsgRTPurchAuthFailed=				"활성화 오류";
var xmsgRTPurchConfirmOther=			"구매 확인";
var xmsgRTPurchConfirmPerm=				"구매 확인 - 등록되고 활성화됨";
var xmsgRTPurchConfirmReg=				"구매 확인 - 등록되었지만 활성화되지 않음";
var xmsgRTPurchConfirmRegVol=			"구매 확인 - 등록됨";
var xmsgRTPurchConfirmRent=				"구매 확인 - 등록되고 임대 활성화됨";
var xmsgRTPurchConfirmUnReg=			"구매 확인 - 등록되지 않거나 활성화되지 않음";
var xmsgRTPurchConnectionFailed=		"구매 연결 실패";
var xmsgRTPurchaseError=				"구매 오류";
var xmsgRTSNMismatch=					"구매 트랜잭션 오류 - 일련 번호 불일치";
var xmsgRTSUNOldSNInvalid=				"유효하지 않은 이전 일련 번호 - SUN";

var szRTEmail =         "RTEmail.html";

var xmsgExit=			"종료";

var xmsgCustIDMainTitle=	"사용자 ID";
var xmsgCustIDTitle1=		"사용자 ID:";
var xmsgCustIDText2=		"아래에 고객 ID와 전화 번호를 입력하십시오. 고객 ID가 없는 경우, 두 필드 모두 비워 두십시오.<p> ";
var xmsgCustIDText3=		"주: 제품을 다시 활성화하려면 고객 ID를 입력해야 합니다.";
var xmsgCustIDText3NSA=		"주: 제품을 다시 권한 부여하려면 고객 ID를 입력해야 합니다.";
var xmsgCustIDTitle2=		"전화 번호:";
var xmsgCustIDTelEx4=		"(예: 03-111-1234)";
var xmsgRegCustIDTel=		"입력하신 고객 ID와 전화 번호가 Autodesk 기록과 일치하지 않습니다. 다음 링크 중 하나를 클릭하십시오.";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"xmsgRT113SeatMsg1" appears in NSA_RT113TooManySeats.html.  The full sentence in English is
//
//	"Our records indicate that you have [Max allowed seats] valid [product name] seats available." 
/////////////////////////////////////////////
var xmsgRT113SeatMsg1=	"기록에 따르면 %1 유효 %2 시트를 사용할 수 있습니다.<br>";

/////////////////////////////////////////////
// Error 12
/////////////////////////////////////////////
var xmsgErr12Hdr=				"입력하신 일련 번호가 유효하지 않습니다";
var xmsgErr12APAC=				"<p>유효하지 않은 일련 번호이므로 활성화할 수 없습니다. " +
								"자세한 내용은 " +
								"<a href=mailto:apacpl@listproc.autodesk.com target=\"_blank\">apacpl@listproc.autodesk.com</a>으로 문의하십시오.</p>";
var xmsgErr12EMEA=				"<p>안녕하십니까?</p>" +
								"<p>Autodesk&#0174; 또는 Discreet&#0153; 소프트웨어 제품을 Autodesk에 등록 신청해 주셔서 감사합니다.</p>" +
								"<p>유감스럽지만 Autodesk 기록에 따르면 등록을 시도하신 Autodesk&#0174; 또는 Discreet&#0153; "+
								"소프트웨어 제품의 일련 번호는 잘못된 번호이거나 해당 소프트웨어 제품의 불법 복사본 "+
								"번호입니다. 즉, 사용하고 계신 Autodesk&#0174; 또는 " +
								"Discreet&#0153; 소프트웨어 제품은 무허가 제품입니다.</p>" +
								"<p>Autodesk&#0174; 소프트웨어 제품의 사용 라이센스는 Autodesk 공인 리셀러에서 구입하실 수 있습니다. " +
								"Autodesk 공인 리셀러 목록이나 각 지역 Autodesk 사무소는 " +
								"<a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a>을 " +
								"참조하십시오. " +
								"소프트웨어 사용에 따르는 이익을 극대화하고 " +
								"소프트웨어 불법 사용 및/또는 복제 사실이 밝혀질 경우의 " +
								"잠재적 민/형사상 고발을 피하는 길은 정식 소프트웨어를 사용하는 것뿐입니다.</p>" +
								"<p>Discreet&#0153; 소프트웨어 제품의 사용 라이센스는 Discreet 공인 리셀러에서 " +
								"구입하실 수 있습니다. Discreet 공인 리셀러 목록이나 각 지역 Discreet 사무소는 " +
								"<a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a>을 " +
								"참조하십시오. " +
								"소프트웨어 사용에 따르는 이익을 극대화하고 " +
								"소프트웨어 불법 사용 및/또는 복제 사실이 밝혀질 경우의 " +
								"잠재적 민/형사상 고발을 피하는 길은 정식 소프트웨어를 사용하는 것뿐입니다.</p>" +
								"<p>그러므로 등록을 신청하신 무허가 소프트웨어 제품의 사용을 즉각 중단하고 " +
								"컴퓨터 하드웨어에 저장된 사본을 모두 제거하신 뒤, " +
								"해당 소프트웨어 제품이 들어 있는 미디어도 파기하실 것을 정중히 요청 드립니다. 여러분이 이러한 요청에 기꺼이 " +
								"따라 주실 것으로 생각하며, Autodesk는 이 문제에 관한 권리를 보유하고 있고 여러분의 정보를 " +
								"Business Software Alliance (\"BSA\")에 통보할 수 있음을 알려 드립니다.</p>" +
								"<p>질문이 있거나 이 메시지가 잘못 전달되었다고 생각하시는 경우, " +
								" " + //modify the e-mail address by joyce.min on 2007-9-3 as the Raptro recommend
								"<a href=mailto:emea.register@activation.autodesk.com target=\"_blank\">emea.register@activation.autodesk.com</a>으로 연락해 주십시오.</p>" +
								"<p>불법 소프트웨어 사용 또는 판매에 관한 정보를 알고 계신 분은 " +
								"해당 지역의 Autodesk 사무소 또는 BSA에 제보해 주십시오. 주소는 " +
								"<a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a>입니다.</p>" +
								"<p>감사합니다.</p>";
var xmsgErr12US=				"<p>안녕하십니까?</p>" +
								"<p>Autodesk 또는 Discreet에 소프트웨어 제품 등록을 신청해 주셔서 감사합니다.</p>" +
								"<p>유감스럽지만 Autodesk 기록에 따르면 등록을 시도하신 Autodesk&#0174; 또는 Discreet&#0153; " +
								"소프트웨어 제품의 일련 번호는 잘못된 번호이거나 해당 소프트웨어 제품의 불법 복사본 " +
								"번호입니다. 즉, 사용하고 계신 Autodesk&#0174; 또는 " +
								"Discreet&#0153; 소프트웨어 제품은 무허가 제품입니다.</p>" +
								"<p>Autodesk 사용자는 Autodesk&#0174; 소프트웨어 제품의 사용 라이센스를 " +
								"Autodesk 공인 리셀러에서 구입하실 수 있습니다. " +
								"<a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a>에서 " +
								"해당 지역의 Autodesk " +
								"공인 리셀러 목록을 참조하십시오. " +
								"소프트웨어 사용에 따르는 이익을 극대화하고 소프트웨어 불법 사용 및/또는 복제 사실이 밝혀질 경우의 " +
								"잠재적 민/형사상 고발을 피하는 길은 정식 소프트웨어를 사용하는 것뿐입니다.</p>" +
								"<p>Discreet&#0153; 사용자는 Discreet&#0153; 소프트웨어 제품의 사용 라이센스를 " +
								"Discreet 공인 리셀러에서 구입하실 수 있습니다. " +
								"<a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a>에서 " +
								"해당 지역의 Discreet 공인 리셀러 목록이나 " +
								"Discreet 사무소를 참조하십시오. 소프트웨어 사용에 따르는 이익을 극대화하고 " +
								"소프트웨어 불법 사용 및/또는 복제 사실이 밝혀질 경우의 " +
								"잠재적 민/형사상 고발을 피하는 길은 정식 소프트웨어를 사용하는 것뿐입니다.</p>" +
								"<p>그러므로 등록을 신청하신 무허가 소프트웨어 제품의 사용을 즉각 중단하고 " +
								"컴퓨터 하드웨어에 저장된 사본을 모두 제거하신 뒤, " +
								"해당 소프트웨어 제품이 들어 있는 미디어도 파기하실 것을 정중히 요청 드립니다. 여러분이 이러한 요청에 기꺼이 " +
								"따라 주실 것으로 생각하며, Autodesk는 이 문제에 관한 권리를 보유하고 있고 여러분의 정보를 Business " +
								"Software Alliance(\"BSA\")에 통보할 수 있음을 알려 드립니다.</p>" +
								"<p>질문이 있거나 이 메시지가 잘못 전달되었다고 생각하시는 경우, " +
								" " +
								"<a href=mailto:ProductActivation@activation.autodesk.com target=\"_blank\">ProductActivation@activation.autodesk.com</a>으로 연락해 주십시오.</p>" +
								"<p>불법 소프트웨어 사용 또는 판매에 관한 정보를 알고 계신 분은 " +
								"해당 지역 사무소 또는 BSA에 제보해 주십시오. 주소는 " +
								"<a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a>입니다.</p>" +
								"<p>감사합니다.</p>";
// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFEbAMsfZ61iQ
// SIG // /wxOTlrI08FI0jX6oIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEHS8VusbS9oziV7CM3V8XDMwDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDkw
// SIG // MzEwMDAwMDAwWhcNMTAwNDA5MjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAmeyo
// SIG // XUqsM3gsliL4M1tThOIixcSmppT1AI04curyMTgKCrT6
// SIG // vIaC74ZsEki5wseN6FoAwzeZUJZWPbbPV0qekjTQySBs
// SIG // OYONAd1oU3S2a86Cujy+zxcfryQA+GqYZuG+j1SsLUy5
// SIG // ASBEv4zkQjfWpHMOI8JRdQr2RgVJ/C3LvFcCAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAEhMhyHuuFsZagEh6O0zAq+6z0EuhaaqI
// SIG // A/hY0xRjZSyBSoQGwwX1pcNyaFf4TTm/xobUutgT7Ct+
// SIG // l/Xl+RbntwVRkyMSKWGX4CtIKuR70vdqREuNEW9exz0M
// SIG // Ck+lZlPZupJe/OA9cZr1x2M296RHRXKK8lCaE5bexPD/
// SIG // k462NFYSZYfs0DwBMz9Ui+kiFcjnsnUpTGoAI7/Xg6Bn
// SIG // t7tzXU5emeIw9AIZt+64XKOvh5BL1VJ/WuD2rjqCwBBP
// SIG // 4NRD2cOa905LKi0qNHp9KyZPE8IJIK2XgTTX9L+Cw7mT
// SIG // Q2kmYtBmz/9/xjeIVrbwEqZeEfbLiSW2QRysH5RA7oou
// SIG // UjGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhB0vFbrG0vaM4lewjN1fFwzMAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFAvo9h5U6zrG5KMQUilwpY7Ej0SSMFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYCG
// SIG // LYFyi2ut1sFWG6Dgydg37z4eR/cKYEcPF/aIUd1YA9aB
// SIG // EAfmbY7UdUIhDeudAe7NVHaHwLkmwzpApaUKPXOMrpYi
// SIG // H+5LLOL7c5MN4YT6DRgvmadvLtnRsvHLoYQuysN8z3yZ
// SIG // 3AHMP+HxsekHubOmPd1ZyRiRuHZ1In3NKod9C6GCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkxMTIwMDAwNzMw
// SIG // WjAjBgkqhkiG9w0BCQQxFgQUtVj9/qd89fGz9eqPv0Hz
// SIG // 9RLJ48IwDQYJKoZIhvcNAQEBBQAEgYBb4opVAsdM+7KE
// SIG // VK6ChRbF/HNg1G0OFrHf6+Jj04vTk1lZvQE1V6C3XHvh
// SIG // G9z9fLV8Ld2+o8oqgaRhIPlN+fPueu0tAGjK5jSvomAh
// SIG // 00Dzz1INCHWyJJwImkQYvN2LqipxX9O8hi8/3tTp4IIf
// SIG // icLgyrOjkZyvH6DdZ59jZNEfGw==
// SIG // End signature block
